/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.ViewInstance;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.NhmEventViewImpl;
import ibm.nways.nhm.eui.NhmResourceManager;
import ibm.nways.nhm.eui.NhmView;
import ibm.nways.nhm.eui.NhmViewPage;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import jclass.bwt.JCTabButton;
import jclass.bwt.JCTabManager;
import jclass.bwt.JCTabManagerEvent;
import jclass.bwt.JCTabManagerListener;

public class NhmViewNotebook
extends JCTabManager
implements JCTabManagerListener,
ItemSelectable {
    Hashtable pages;
    DpmClientApplet dpmClient;
    NhmResourceManager resource;
    Applet applet;
    NhmViewPage currentPage;
    private static ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    private static final String LOADING_MESSAGE = nhmRes.getString("s_Loading");
    private static final String COMPLETE_MESSAGE = nhmRes.getString("s_Complete");
    private static final String DRAWING_MESSAGE = nhmRes.getString("s_Drawing");
    private ItemListener itemListener;

    public NhmViewNotebook(DpmClientApplet dpmClientApplet, NhmResourceManager nhmResourceManager) {
        this(dpmClientApplet, nhmResourceManager, null);
    }

    public NhmViewNotebook(DpmClientApplet dpmClientApplet, NhmResourceManager nhmResourceManager, Applet applet) {
        this.applet = applet;
        this.dpmClient = dpmClientApplet;
        this.resource = nhmResourceManager;
        this.setTabShape(1);
        this.setTabResize(false);
        this.setTabStretch(false);
        this.setTabColorPolicy(1);
        this.addTabManagerListener(this);
        this.pages = new Hashtable();
        this.addPage(new NhmEventViewImpl(dpmClientApplet, nhmResourceManager));
    }

    public void reshape(int n, int n2, int n3, int n4) {
        try {
            super.reshape(n, n2, n3, n4);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public NhmResourceManager getResourceManager() {
        return this.resource;
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            NhmViewPage nhmViewPage = (NhmViewPage)enumeration.nextElement();
            nhmViewPage.unregisterForEvents(dpmClientApplet);
        }
    }

    public void tabManagerChangeBegin(JCTabManagerEvent jCTabManagerEvent) {
        Cursor cursor = this.getParent().getCursor();
        this.getParent().setCursor(new Cursor(3));
        JCTabButton jCTabButton = jCTabManagerEvent.getNextTab();
        ViewInstance viewInstance = null;
        NhmViewPage nhmViewPage = (NhmViewPage)this.pages.get(jCTabButton.getUserData());
        if (nhmViewPage instanceof NhmView) {
            NhmView nhmView = (NhmView)nhmViewPage;
            if (nhmView.getViewInstance() == null || nhmViewPage == this.currentPage) {
                long l = 0L;
                long l2 = System.currentTimeMillis();
                Date date = this.resource.dpGetStartTime();
                Date date2 = this.resource.dpGetEndTime();
                if (date == null && date2 == null) {
                    try {
                        this.displayMessage(LOADING_MESSAGE);
                        viewInstance = this.dpmClient.getViewInstance(nhmView.getTitle(), this.resource.dpGetHostname(), this.resource.dpGetResourceInstance());
                        this.displayMessage(DRAWING_MESSAGE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    if (date != null) {
                        l = date.getTime();
                    }
                    if (date2 != null) {
                        l2 = date2.getTime();
                    }
                    try {
                        this.displayMessage(LOADING_MESSAGE);
                        viewInstance = this.dpmClient.getViewInstance(nhmView.getTitle(), this.resource.dpGetHostname(), this.resource.dpGetResourceInstance(), l, l2);
                        this.displayMessage(DRAWING_MESSAGE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (viewInstance != null) {
                    viewInstance.setupGraphData(this.dpmClient);
                    nhmView.setViewInstance(viewInstance);
                } else {
                    Traces.logError(this, "Server returned null view instance");
                }
                this.displayMessage(COMPLETE_MESSAGE);
            } else {
                nhmView.updateView();
            }
        } else if (nhmViewPage instanceof NhmEventViewImpl) {
            NhmEventViewImpl nhmEventViewImpl = (NhmEventViewImpl)nhmViewPage;
            if (nhmEventViewImpl.numberOfComponents() == 0 || nhmViewPage == this.currentPage) {
                this.displayMessage(LOADING_MESSAGE);
                nhmEventViewImpl.recreateView();
                this.displayMessage(COMPLETE_MESSAGE);
            } else {
                nhmEventViewImpl.updateView();
            }
        }
        this.currentPage = nhmViewPage;
        this.currentPage.invalidate();
        this.currentPage.validate();
        this.getParent().setCursor(cursor);
    }

    public void tabManagerChangeEnd(JCTabManagerEvent jCTabManagerEvent) {
        if (this.itemListener != null && this.currentPage != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.currentPage, 1));
        }
    }

    public void showPage(String string) {
        int n = this.getPagePosition(string);
        this.setCurrentTab(n, true);
    }

    public void showPage(NhmViewPage nhmViewPage) {
        this.showPage(nhmViewPage.getTitle());
    }

    public void addPage(NhmViewPage nhmViewPage) {
        String string = nhmViewPage.getTitle();
        this.pages.put(string, nhmViewPage);
        int n = super.addPage(nhmViewPage.getTitle(), nhmViewPage);
        JCTabButton jCTabButton = this.getTab(n);
        jCTabButton.setBackground(Color.lightGray);
        jCTabButton.setForeground(Color.black);
        jCTabButton.setUserData(string);
    }

    public void addPage(String string) {
        this.addPage(new NhmView(string, this.dpmClient));
    }

    public void removePage(NhmViewPage nhmViewPage) {
        this.removePage(nhmViewPage.getTitle());
    }

    public void removePage(String string) {
        this.pages.remove(string);
    }

    public int getPagePosition(String string) {
        int n = -1;
        String[] stringArray = this.getTabLabels();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        return this.pages.toString();
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getCurrentPage()};
        return objectArray;
    }

    public void displayMessage(String string) {
        if (this.applet instanceof BrowserApplet) {
            ((BrowserApplet)this.applet).displayMsg(string);
            return;
        }
        this.applet.showStatus(string);
    }
}

